.\" Automatically generated by Pod::Man version 1.02
.\" Thu Mar 14 07:02:07 2002
.\"
.\" Standard preamble:
.\" ======================================================================
.de Sh \" Subsection heading
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Ip \" List item
.br
.ie \\n(.$>=3 .ne \\$3
.el .ne 3
.IP "\\$1" \\$2
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R

.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  | will give a
.\" real vertical bar.  \*(C+ will give a nicer C++.  Capital omega is used
.\" to do unbreakable dashes and therefore won't be available.  \*(C` and
.\" \*(C' expand to `' in nroff, nothing in troff, for use with C<>
.tr \(*W-|\(bv\*(Tr
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` `
.    ds C' '
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" If the F register is turned on, we'll generate index entries on stderr
.\" for titles (.TH), headers (.SH), subsections (.Sh), items (.Ip), and
.\" index entries marked with X<> in POD.  Of course, you'll have to process
.\" the output yourself in some meaningful fashion.
.if \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
.    .
.    nr % 0
.    rr F
.\}
.\"
.\" For nroff, turn off justification.  Always turn off hyphenation; it
.\" makes way too many mistakes in technical documents.
.hy 0
.if n .na
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.bd B 3
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ======================================================================
.\"
.IX Title "HASHCASH 1"
.TH HASHCASH 1 "0.14" "2002-03-14" "hashcash"
.UC
.SH "NAME"
hashcash \- hashcash minting and verification command line tool
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
.Sh "Mint (create) token:"
.IX Subsection "Mint (create) token:"
\&\fBhashcash\fR [ \fIoptions\fR ] [ \fI\-b bits\fR ] [ \fIresource\fR ]>
.Sh "Check token:"
.IX Subsection "Check token:"
\&\fBhashcash\fR \fI\-c\fR [ \fIoptions\fR ] \fI\-b bits\fR \fI\-r resource\fR [ \fItoken\fR ]
.Sh "Speed estimates:"
.IX Subsection "Speed estimates:"
\&\fBhashcash\fR \fI\-s\fR [ \fIoptions\fR ] [ \fI\-b bits\fR ]
.Sh "Purge database:"
.IX Subsection "Purge database:"
\&\fBhashcash\fR \fI\-p now\fR [ \fI\-j resource\fR ] [ \fI\-k\fR ] [ \fI\-t time\fR ] [ \fI\-u\fR ]
.Sh "Count collision bits:"
.IX Subsection "Count collision bits:"
\&\fBhashcash\fR \fI\-w\fR [ \fIoptions\fR ] [ \fItoken\fR ]
.Sh "Get resource name:"
.IX Subsection "Get resource name:"
\&\fBhashcash\fR \fI\-n\fR [ \fIoptions\fR ] [ \fItoken\fR ]
.Sh "Get time remaining until expiry"
.IX Subsection "Get time remaining until expiry"
\&\fBhashcash\fR \fI\-l\fR [ \fIoptions\fR ] \fI\-e period\fR [ \fItoken\fR ]
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
Hashcash is a DoS counter-measure tool.  This tool allows you to mint
(create) and verify hashcash tokens.  A hashcash token constitutes a
proof-of-work which takes a parameterizable amount of work to compute
for the sender.  The recipient can verify received tokens efficiently.
.PP
The proof-of-work function is to compute partial hash collisions (in
this version the \s-1SHA1\s0 hash function is used).  By choosing the number
of bits of collision, the work required to compute a collision can be
made arbitrarily expensive \*(-- from fractions of a second to minutes or
hours.  The verification is efficient requiring the same small cost
whatever the collision size.
.PP
For more detailed discussion of potential applications for hashcash
see http://www.cypherspace.org/hashcash/.
.SH "USAGE NOTES"
.IX Header "USAGE NOTES"
.Sh "Minting tokens"
.IX Subsection "Minting tokens"
If neither the \fI\-c\fR or \fI\-s\fR option are given, it is assumed that you
want to mint a token.
.PP
The resource name to mint the token against can be passed as an
argument, or if omitted is read from stdin.  If stdin is a tty the
user is prompted, if stdin is a pipe the resource name is just
silently read.  The desired collision size can be specified with the
\&\-b option.  If no collision size is specified, the default is 20 bits.
As a convenience, if stdin is a tty and no collision size is given
with the \fI\-b\fR flag, the user is prompted for a collision size.
.Sh "Checking tokens"
.IX Subsection "Checking tokens"
The \fI\-c\fR flag must be given to check tokens.  The token to check can
be given as an argument to \f(CW\*(C`hashcash\*(C'\fR.  If no token is given the
token is read from stdin.  If stdin is a tty the user will be
prompted, if stdin is a pipe the token is just silently read.  A
resource name can be given with the \fI\-r\fR option.  If a resource name
is given the resource name is compared to the name in the token, if
they do not match, the token is rejected.
.PP
Note: if no resource name is given the token is anyway checked to see
if it is otherwise valid, but it could be minted for a different
resource, which would allow tokens to be reused across different
resources, so hashcash will return unchecked exit code on exit.
.PP
Tokens are by default considered to be valid forever.  The validity
period can be changed using the \fI\-e\fR flag.
.PP
If the token has expired or has a date in the future the token is
rejected and the program exits immediately.
.PP
If a required collision size is given with the \fI\-b\fR flag, the tokens
value is computed and compared, if the token has insufficent value it
is rejected, and the program exits immediately.  If the \fI\-b\fR flag is
not given, the token could be of any size, so hashcash will return
unchecked exit code on exit.
.PP
If the token is double spent the token is rejected.  Double spending
protection is discussed in more detail below in 
the Double Spending Protection entry elsewhere in this document.  If double spending protection is not
enabled, the token could be double spent, so hashcash will return
unchecked exit code on exit.
.PP
The \fI\-w\fR flag can be used to request that the number of bits of the
collision are counted and displayed; exit code unchecked is returned
on exit.  The \fI\-n\fR flag can be used to request that the resource name
in the token is parsed out and displayed; exit code unchecked is
returned on exit.  The \fI\-l\fR flag can be used to request the number of
seconds until expiry of the token is output; exit code unchecked is
returned on exit.
.PP
The program will only return exit codes valid or invalid if the \fI\-c\fR
flag is used, and all of the options \fI\-b bits\fR, \fI\-d\fR, \fI\-r resource\fR
are used.  These are the minimum set of options necessary to check the
validty of a token.  If these criteria are not met, the program will
return exit code unchecked on exit.
.Sh "Double Spending Protection"
.IX Subsection "Double Spending Protection"
If the \fI\-d\fR flag is used with the \fI\-c\fR flag a database of spent
tokens is kept.  
.PP
By default tokens do not expire, and over time the database will grow
indefinately.  To prevent this, you can specify an expiry period with
the \fI\-e\fR flag.  A recommended expiry period is 28 days.  After the
expiry period amount of time, the token is anyway considered expired
and may be purged from the database to save space.  (See 
the Purging Periodically vs on Next Access entry elsewhere in this document for how to purge tokens.)
.PP
For efficiency reasons a token is verified before it is checked in the
database; if it is otherwise invalid no database activity will occur.
.PP
Note: The decision about how long the token should be considered valid
is up to the verifier.  If it is too short it is possible for some
applications that the token will expire before arriving at the
recipient (eg with email.)  The suggested value of 28 days should be
safe for normal email delivery delays.  The choice is a trade-off
between database size and risk of expiry prior to arrival, and depends
on the application.
.PP
Note: Different tokens in the same database can have different
validity periods, so for example tokens for different resources with
different validity periods can be stored in the same database, or the
recipient may change the validity period for future tokens without
affecting the validity of old tokens.
.Sh "Purging Periodically vs on Next Access"
.IX Subsection "Purging Periodically vs on Next Access"
To purge old tokens periodically while checking tokens use the \fI\-p
period\fR option to purge no sooner than the given time period since the
last purge.  Purging can be used with the \fI\-k\fR to purge unexpired
tokens also, and with the \fI\-r resource\fR flag to purge only tokens for
the given resource.
.PP
There are circumstances where it may be inconvenient to purge tokens
on the next access, for example if there is a large double spend
database which takes some time to purge, and the response time of the
hashcash checker is important.  To avoid this problem, purging can be
done separately using just the \fI\-p now\fR option to request just the
purge operation.  On unix for example you could call \f(CW\*(C`hashcash \-p
now\*(C'\fR in a cron job once per day, or on demand when disk was running
low.
.Sh "Speed Estimates"
.IX Subsection "Speed Estimates"
The \fI\-s\fR flag requests measurement of how many collisions can be
tested per second.  No token is minted, or verified.
.PP
If the \fI\-b\fR flag is used this option, instead an estimate of how many
seconds it would take to mint a token of that size is computed.
.Sh "Notes"
.IX Subsection "Notes"
All informational output is printed on stderr.  Minted tokens, and
results of token verification and timing are printed on stdout.  The
quiet flag \fI\-q\fR suppresses all informational output.  The \fI\-v\fR flag
requests more informational output.  The requested output, which is
the only information that is output in quiet mode (when \fI\-q\fR is
specified) is printed on standard output.  If stdout is a pipe the
output is printed without description (ie just bits, just seconds,
just resource).
.SH "OPTIONS"
.IX Header "OPTIONS"
.Ip "\fI\-c\fR" 4
.IX Item "-c"
Check the token given as an argument or on stdin for validity.
.Ip "\fI\-m\fR" 4
.IX Item "-m"
Mint a token.  If none of \fI\-c\fR, \fI\-p\fR, \fI\-s\fR, \fI\-l\fR, \fI\-n\fR, \fI\-w\fR are
given it is anyway assumed that the user wishes to mint a token.
.Ip "\fI\-b bits\fR" 4
.IX Item "-b bits"
When minting a token, request a collision of this many bits.  When
verifying a token require that it have a collision of at minimum this
many bits, otherwise reject it.
.Ip "\fI\-r resource\fR" 4
.IX Item "-r resource"
When minting tokens, the resource name to mint the token against can
be given either with \fI\-r resource\fR or as an argument to \f(CW\*(C`hashcash\*(C'\fR.
.Sp
When checking tokens, the resource name can be given with the \fI\-r\fR
option.  If the resource name is given it is checked against the
resource name in the token, and if they do not match the token is
rejected.  Note if the resource name is not given, tokens for other
resources would be accepted, and therefore hashcash returns exit code
unchecked on exit.
.Ip "\fI\-e time\fR" 4
.IX Item "-e time"
Expiry period for spent tokens.  While checking tokens (using the
\&\fI\-c\fR flag), if the token was minted more than the specified amount of
time ago, it is considered expired.  If this option is not used, by
default tokens do not expire (they have an expiry period of forever).
The expiry period is given in seconds by default (an argument of 0
means forever).  A single character suffix can be used to specify
alternate units (m = minutes, h = hours, d = days, M = months, y = Y =
years, and s = seconds).
.Sp
If used with the \fI\-d\fR option, the spent token and it's expiry period
is recorded in the database.  See the \fI\-p\fR option for description of
how to purge tokens from the database.
.Sp
While minting tokens, if the \fI\-e\fR flag can have an effect on the
resolution of time created in the token.  Without the \fI\-e\fR option,
the default resolution is days (time format: \s-1YYMMDD\s0).  Alternate
formats based on range of expiry period are as follows:
.RS 4
.Ip "\(bu period >= 2 years then time format \s-1YY\s0 is used rounded down to the nearest year start;" 8
.IX Item "period >= 2 years then time format YY is used rounded down to the nearest year start;"
.Ip "\(bu 2 years < period <= 2 months then time format \s-1YYMM\s0 is used rounded down to the nearest month start;" 8
.IX Item "2 years < period <= 2 months then time format YYMM is used rounded down to the nearest month start;"
.Ip "\(bu 2 months < period <= 2 days then time format \s-1YYMMDD\s0 is used rounded down to the begining of the nearest day;" 8
.IX Item "2 months < period <= 2 days then time format YYMMDD is used rounded down to the begining of the nearest day;"
.Ip "\(bu 2 days < period <= 2 hours then time format YYMMDDhh is used rounded down to the begining of the nearest hour;" 8
.IX Item "2 days < period <= 2 hours then time format YYMMDDhh is used rounded down to the begining of the nearest hour;"
.Ip "\(bu 2 hours < period <= 2 minutes then time format YYMMDDhhmm is used rounded down to the begining of the nearest minute;" 8
.IX Item "2 hours < period <= 2 minutes then time format YYMMDDhhmm is used rounded down to the begining of the nearest minute;"
.Ip "\(bu period < 2 minutes then time format YYMMDDhhmmss is used in seconds." 8
.IX Item "period < 2 minutes then time format YYMMDDhhmmss is used in seconds."
.RE
.RS 4
.Sp
Note the rounding down is based on \s-1UTC\s0 time, not local time.  This can
lead to initially suprising results when rounding down to eg days in
time zones other than \s-1GMT\s0 (\s-1GMT\s0 = \s-1UTC\s0).  It may be clearer to
understand if you use the \fI\-u\fR option.
.RE
.Ip "\fI\-d\fR" 4
.IX Item "-d"
Store tokens in a double spend database.  If token has been seen
before it will be rejected even if it is otherwise valid.  The default
database file is \fIdatabase.db\fR in the current directory.
.Sp
It is recommended that if you use the \fI\-e\fR option with the database
option, to prevent the database growing indefinately over time.  A
suggested value is \fI\-e 28d\fR, 28 days.
.Ip "\fI\-f dbname\fR" 4
.IX Item "-f dbname"
Use \fIdbname\fR instead of default filename for double spend database.  
.Ip "\fI\-p period\fR" 4
.IX Item "-p period"
Purges the database of expired tokens if the given time period has
passed since the last time it was purged.  As a convenience \fI\-p now\fR
is equivalent to \fI\-p 0\fR both of which mean purge now, regardless of
when the database was last purged.  
.Sp
If used in combination with \fI\-j resource\fR only the tokens minted for
the given resource are purged.
.Sp
If used in combination with \fI\-k\fR all tokens even un-expired tokens
are purged.  Can be used in combination with \fI\-t time\fR to expire as
if the current time were the given time.
.Ip "\fI\-k\fR" 4
.IX Item "-k"
Use with option \fI\-p\fR to request all tokens are purged rather than
just expired ones.
.Ip "\fI\-j resource\fR" 4
.IX Item "-j resource"
Use with option \fI\-p\fR to request that just tokens matching the given
resource name are to be purged, rather than the default which is to
purge all expired tokens.  If the resource name is the empty string,
all tokens are matched (this is equivalent to omitting the \fI\-j\fR
option).
.Ip "\fI\-s\fR" 4
.IX Item "-s"
Print timing information only don't find collision.  If combined with
\&\fI\-b\fR flag print estimate of how long the requested collision size
would take to compute, if \fI\-s\fR given by itself, just prints speed of
collision finder.
.Ip "\fI\-h\fR" 4
.IX Item "-h"
Print short usage information.
.Ip "\fI\-v\fR" 4
.IX Item "-v"
Print more verbose informational output about the token minting or
verification.
.Ip "\fI\-q\fR" 4
.IX Item "-q"
Batch mode.  Prints no information other than output.  This option
overrides the \fI\-v\fR option.
.Ip "\fI\-x string\fR" 4
.IX Item "-x string"
When minting, prints the string before the token.  An example might be
\&\fI\-x 'X-Hashcash: '\fR, to insert as a mail header.  Without this option
just the bare token is printed.
.Sp
When checking, if no token is given as an argument, scans stdin for a
line starting with the given string, and use the rest of the matching
as the token.  Only the lines up to and ending at the first blank line
are scanned.  A blank line is the separator used to separate the
headers from the body of a mail message or \s-1USENET\s0 article.  This is
meant to make it convenient to pipe a mail message or \s-1USENET\s0 article
to hashcash on stdin.
.Ip "\fI\-i\fR" 4
.IX Item "-i"
When checking and using the \fI\-x\fR flag, ignore the blank line boundary
between headers and body of the message, and check for collision in
the body too if one is not found in the headers.
.Ip "\fI\-t time\fR" 4
.IX Item "-t time"
Pretend the current time is the time given for purposes of minting
tokens, verifying tokens and purging old tokens from the database.
Time is given in a format based on \s-1UTCTIME\s0 format
YYMMDD[hh[mm[ss]]]['Z'] \*(-- the 'Z' is optional.
.Sp
Time is expressed in local time by default.  Use with \fI\-u\fR flag to
give time in \s-1UTC\s0 (\s-1GMT\s0).
.Sp
You can also give time relative to the current time by prefixing the
argument with + or \-.  The default units for relative time are
seconds.  A single character suffix can be used to specify alternate
units (m = minutes, h = hours, d = days, M = months, y = Y = years,
and s = seconds).
.Ip "\fI\-u\fR" 4
.IX Item "-u"
Input and output absolute times in \s-1UTC\s0 (\s-1GMT\s0) instead of local time.
.Ip "\fI\-z\fR" 4
.IX Item "-z"
Use strict \s-1UTCTIME\s0 format: YYMMDDhhmm[ss]'Z' rather than the \s-1UTCTIME\s0
based extension normally used which omits 'Z', and makes more time
units optional for lower resolution times as described under the \fI\-t\fR
option.
.Ip "\fI\-a period\fR" 4
.IX Item "-a period"
Add (or subtract if number is negative) a random value from the
current time before minting the token.  This hides the time the token
was created, which may be useful for anonymous users.  Note adding
(rather than subtracting) a random time may be risky if the token
takes less than the added time to arrive as the recipient will reject
tokens with time stamps in the future.
.Ip "\fI\-n\fR" 4
.IX Item "-n"
Print resource name parsed from token being verified.  Returns exit
code unchecked on exit.
.Ip "\fI\-l\fR" 4
.IX Item "-l"
Print number of seconds left before token expires.  Returns exit code
unchecked on exit.
.Ip "\fI\-w\fR" 4
.IX Item "-w"
Print number of bits of collision of token.  Returns exit code
unchecked on exit.
.Ip "\fI\-y\fR" 4
.IX Item "-y"
Returns success if the token is valid even if it is not fully checked.
Use with \fI\-c\fR where not all of \fI\-b\fR, \fI\-d\fR, \fI\-r\fR are specified to
get success exit code on valid but partially checked token.  Similarly
can use with \fI\-n\fR, \fI\-l\fR, \fI\-w\fR with same effect.
.SH "EXAMPLES"
.IX Header "EXAMPLES"
.Sh "Creating tokens"
.IX Subsection "Creating tokens"
.Ip "\f(CW\*(C`hashcash \-s\*(C'\fR" 4
.IX Item "hashcash -s"
Print timing information about how many collisions the machine can try
per second.
.Ip "\f(CW\*(C`hashcash \-s \-b 32\*(C'\fR" 4
.IX Item "hashcash -s -b 32"
Print how long it would take the machine to compute a 32 bit collision
(but don't actually compute a collision).
.Ip "\f(CW\*(C`hashcash\*(C'\fR" 4
.IX Item "hashcash"
Mint a token.  Will prompt for resource name and desired value (number
of collision bits).
.Ip "\f(CW\*(C`hashcash foo\*(C'\fR" 4
.IX Item "hashcash foo"
Compute collision on resource foo.  Will prompt desired value (number
of collision bits).
.Ip "\f(CW\*(C`hashcash foo \-b 10\*(C'\fR" 4
.IX Item "hashcash foo -b 10"
Compute 10 bit collision on resource foo.
.Ip "\f(CW\*(C`hashcash \-a \-3d\*(C'\fR" 4
.IX Item "hashcash -a -3d"
Subtract a random time of between 0 days and 3 days to to the token's
creation time.  This is the same fuzz factor used by mixmaster to
reduce risk of timing-correlations.
.Sh "Examining Tokens"
.IX Subsection "Examining Tokens"
.Ip "\f(CW\*(C`hashcash \-w 020312:foo:88dab6b5cb593991\*(C'\fR" 4
.IX Item "hashcash -w 020312:foo:88dab6b5cb593991"
Report the value of the token (how many bits of collision) there are.
The example is a 33 bit collision, which would take on average 13
hours to create on a 400 Mhz Pentium-II.
.Ip "\f(CW\*(C`hashcash \-q \-b 10 foo | hashcash \-w\*(C'\fR" 4
.IX Item "hashcash -q -b 10 foo | hashcash -w"
Create a token in batch mode, pass to hashcash on stdin to verify,
have it print how many bits there were.  Note: half of the time you
get a token 1 bit larger; similarly with decreasing probability you
can get even larger tokens.
.Ip "\f(CW\*(C`hashcash \-n 020312:foo:72dcdc01a42589a0\*(C'\fR" 4
.IX Item "hashcash -n 020312:foo:72dcdc01a42589a0"
Report the resource name from the token.  The resource name in the
example is foo.
.Ip "\f(CW\*(C`hashcash \-l \-e 30y 020312:foo:72dcdc01a42589a0\*(C'\fR" 4
.IX Item "hashcash -l -e 30y 020312:foo:72dcdc01a42589a0"
Report how long until the token expires if it expires in 30 years from
it's creation date.  (Note dates too far into the future run into the
2038 end of Epoch, which is the unix time analog of the y2k bug).
.Sh "Verifying Tokens"
.IX Subsection "Verifying Tokens"
.Ip "\f(CW\*(C`hashcash \-c 020312:foo:72dcdc01a42589a0\*(C'\fR" 4
.IX Item "hashcash -c 020312:foo:72dcdc01a42589a0"
Check if the token is valid.  Note as we are not checking the token in
a double spend database, and did not specify a resource name or
required number of bits of collision and hashcash will consider the
token not fully checked, and it will report it as valid but not fully
unchecked, or as invalid if there is any problem with the token.
.Ip "\f(CW\*(C`hashcash \-c \-b24 020312:foo:72dcdc01a42589a0\*(C'\fR" 4
.IX Item "hashcash -c -b24 020312:foo:72dcdc01a42589a0"
Check that the value of the token is greater or equal to 24 bits.
This example has 24 bit value.  If you increase the requested number
of bits or replace the token with one with less than 24 bit collision
the token will be rejected.
.Ip "\f(CW\*(C`hashcash \-c \-b 24 \-r foo 020312:foo:72dcdc01a42589a0\*(C'\fR" 4
.IX Item "hashcash -c -b 24 -r foo 020312:foo:72dcdc01a42589a0"
As above check if the token has sufficient value, but in addition
check that the resource name given matches the resource name in the
token.
.Sh "Double Spending Prevention"
.IX Subsection "Double Spending Prevention"
The examples given in the Verifying Tokens entry elsewhere in this document can be modified to keep a
double spend database so that the same token will not be accepted
twice.  Note a token will only be checked in and added to the database
if it is otherwise valid and fully checked (a required number of bits
of collision has been specified and a resource has been specified).
.Ip "\f(CW\*(C`hashcash \-cd \-b 10 \-r foo 020312:foo:72dcdc01a42589a0\*(C'\fR" 4
.IX Item "hashcash -cd -b 10 -r foo 020312:foo:72dcdc01a42589a0"
Check the token and add to double spent database if it's valid (has
correct resource name and sufficient value).
.Ip "\f(CW\*(C`hashcash \-cd \-b 10 \-r foo 020312:foo:72dcdc01a42589a0\*(C'\fR" 4
.IX Item "hashcash -cd -b 10 -r foo 020312:foo:72dcdc01a42589a0"
Try to double spend the token.  It will be rejected as double spent.
.Sh "Token Expiry"
.IX Subsection "Token Expiry"
To prevent the double spend database growing indefinately, the
recipient can request that tokens be no older than a specified period.
After expiry old tokens can dropped from the double spend database as
they will no longer be needed \*(-- expired tokens can be rejected based
purely on their old date, so the space taken by expired tokens in the
double spend database can be saved without risk of accepting an
expired though otherwise valid token.
.PP
The first field of the token is the \s-1UTC\s0 time since 1st January 1970.
The default time format is \s-1YYMMDD\s0, time rounded down to the nearest
day.  The default validity period is forever.
.PP
You can provide an alternative validity period with the \fI\-e\fR option.
.Ip "\f(CW\*(C`hashcash \-cd \-b 10 \-e 2d \-r foo 020311:foo:835fa2b0b8c692cc\*(C'\fR" 4
.IX Item "hashcash -cd -b 10 -e 2d -r foo 020311:foo:835fa2b0b8c692cc"
Try verifying an old token, the above token was created 11 Mar 2002.
.Sp
We gave option \fI\-e 2d\fR so the tokens expiry date is 2 days after
creation, which is now in the past.
.Sp
Note: if the creation time is expressed in the token in days, the
precise creation date is the begining of the specified day in \s-1UTC\s0 time
(similarly for alternate units the creation time is rounded down to
the begining of the unit it is expressed in).  For units in days, for
example, this may mean depending on your time zone that the token
appears to be considered invalid in under the specified expiry period
in days relative to your relative view of what day it is, as the
calculation is based on current time in \s-1UTC\s0, and the creation time of
the token is expressed in \s-1UTC\s0 time.
.Ip "\f(CW\*(C`hashcash \-cd \-b 10 \-r foo 020311:foo:835fa2b0b8c692cc\*(C'\fR" 4
.IX Item "hashcash -cd -b 10 -r foo 020311:foo:835fa2b0b8c692cc"
Test whether the token is otherwise valid, apart from having expired.
Omitting the \fI\-e\fR tells hashcash that the token will never expire.
An expiry period of forever can also be given explitly like this: \fI\-e
0\fR, where an expiry period of 0 means forever.
.Sh "Purging old tokens"
.IX Subsection "Purging old tokens"
If the \fI\-c\fR, \fI\-d\fR options are used together, each time a token is
checked, if it is valid and all of the mandatory aspects of the token
are verified (collision bits check, resource name check) then the
token and it's expiry period is written to the database file.  The
default expiry period if an expiry period is not given explicitly with
the \fI\-e\fR option is forever (ie tokens do not expire).
.PP
First mint and then add a token:
.Ip "\f(CW\*(C`hashcash \-b 10 foo \-e 1m > token\*(C'\fR" 4
.IX Item "hashcash -b 10 foo -e 1m > token"
Note: we specified an expiry on minting in this example, to ensure
that the token creation time is given in high enough resolution in the
token that the token will not be considered expired at time of
creation.  (Recall the default resolution is in days, a token created
with a creation time rounded down to the beginging of the day is
unlikely to be considered valid 1 minute later unless you mint it at
midnight \s-1UTC\s0 time.)
.Ip "\f(CW\*(C`hashcash \-cd \-e 1m \-b 10 \-r foo < token\*(C'\fR" 4
.IX Item "hashcash -cd -e 1m -b 10 -r foo < token"
The token expires in 1 minute.  Wait 1 minute and then explicitly
request that expired tokens be purged:
.Ip "\f(CW\*(C`hashcash \-p now\*(C'\fR" 4
.IX Item "hashcash -p now"
Then try resubmitting the same token:
.Ip "\f(CW\*(C`hashcash \-cd \-e 1m \-b 10 \-r foo < token\*(C'\fR" 4
.IX Item "hashcash -cd -e 1m -b 10 -r foo < token"
and the token will be rejected anyway as it has expired, illustrating
why it was not necessary to keep this token in the database.
.Sp
With the default database (the sdb format) the database contents are
human readable, so you can view their contents by cating them to the
terminal:
.Ip "\f(CW\*(C`cat hashcash.db\*(C'\fR" 4
.IX Item "cat hashcash.db"
to see that the token really is added and then after puring
subsequently purged due to expiry.
.Sh "Purging old tokens on Demand"
.IX Subsection "Purging old tokens on Demand"
As a convenience you can purge at the same time as checking tokens by
using the \fI\-p\fR option with the \fI\-c\fR option.
.Ip "\f(CW\*(C`hashcash \-b 10 foo > token\*(C'\fR =item \f(CW\*(C`hashcash \-cd \-p now \-e 1 \-b 10 \-r foo < token\*(C'\fR" 4
.IX Item "hashcash -b 10 foo > token =item hashcash -cd -p now -e 1 -b 10 -r foo < token"
It may be inefficient to purge tokens on every use as the entire
database has to be scanned for expired tokens.  By giving a time
period to the \fI\-p\fR option, you can tell \f(CW\*(C`hashcash\*(C'\fR to purge no more
frequently than that time period since the previous purge.
.Sp
For example:
.Ip "\f(CW\*(C`hashcash \-cd \-p 1d \-e 1 \-b 10 \-r foo < token\*(C'\fR" 4
.IX Item "hashcash -cd -p 1d -e 1 -b 10 -r foo < token"
tells \f(CW\*(C`hashcash\*(C'\fR to purge any expired tokens no more than once per
day.
.Ip "\f(CW\*(C`hashcash \-p 1M \-j foo\*(C'\fR" 4
.IX Item "hashcash -p 1M -j foo"
tells \f(CW\*(C`hashcash\*(C'\fR to purge only expired tokens matching resource foo
once per month.
.Ip "\f(CW\*(C`hashcash \-p now \-k\*(C'\fR" 4
.IX Item "hashcash -p now -k"
tells \f(CW\*(C`hashcash\*(C'\fR to purge all tokens (expired and unexpired) now.
.SH "FILES"
.IX Header "FILES"
.Ip "\fIhashcash.db\fR" 4
.IX Item "hashcash.db"
default double spend database
.Ip "\fIhashcash.dbt\fR" 4
.IX Item "hashcash.dbt"
default temporary double spend database used when purging tokens.
.SH "EXIT STATUS"
.IX Header "EXIT STATUS"
\&\f(CW\*(C`hashcash\*(C'\fR returns success (exit code 0) after successfully minting a
token, after fully checking a token and finding it valid, and after a
timing test.
.PP
If when checking a token it is found to be invalid (due to being
malformed, being expired, having insufficient value, having a date in
the future, or being double spent), \f(CW\*(C`hashcash\*(C'\fR returns failure (exit
code 1).
.PP
If insufficient options are given to fully check a token, or if using
the \fI\-n\fR, \fI\-l\fR, or \fI\-w\fR options, if the token is otherwise valid
return unchecked (exit code 2).  If the \fI\-y\fR flag is given and
hashcash would normally return unchecked, exit code success is
returned instead.
.PP
If any exception occurs (file read failure for database checking or
corrupted database contents) an exit status of 3 is returned.
.SH "AUTHOR"
.IX Header "AUTHOR"
Written by Adam Back <adam@cypherspace.org>
.SH "SEE ALSO"
.IX Header "SEE ALSO"
\&\fIsha1\fR\|(1), http://www.cypherspace.org/hashcash/
